/*****************************************************************************
*
* "VDB_OVERRIDES_GRT.cpp"
*
*  THIS CODE IS FOR ILLUSTRATIVE PURPOSES ONLY. IT IS NOT PRODUCTION READY.
***
*/

// The following #include is required as the first real line within your
// C++ files.  Don't place any other #includes before this one!
#include "pch.h"
#include "ius_utllib.h"
#include "remote.h"
#include "connection.h"
#include "dbnum.h"

// The following macro ensures that functions referenced within this file will be exported.
#define VDB_OVERRIDES_REMOTE_SOURCE


static oas_boolean_t GRTremote_assignConn(slot dbNumber, slot recNumber, char* comStr, user uPriv,
    TRegEx& regExp, VDBERROR* pDberr);
static oas_boolean_t abc(slot dbNumber, slot recNumber, char* comStr, user uPriv,
    TRegEx& regExp, VDBERROR* pDberr);

static oas_boolean_t updateEmpriseValue(slot remoteNumber, slot connNumber, int empriseValue, VDBERROR* pDberr);

/*******************************************************************
**
**  Function:   LIBAPP_init_axs_table
** 
**  Purpose:    This function is called by the init_axs_table
**              routine to perform any additional initialization.
**
**  Output:     Returns OAS_TRUE if successful, else OAS_FALSE.
**
**  Note:       Leave this routine unchanged.
*/
extern "C" VDB_OVERRIDES_REMOTE oas_boolean_t LIBAPP_init_axs_table()
{
    return OAS_TRUE;
}


V_FNPUTTABLE(app_remoteFputTbl) = {
    V_FNPUT("^[ \t]*GRTASSIGNCONN[ \t]+([-+A-Za-z0-9_!#$^&*=|{}<>?`~]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([Yy]es)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]+)", GRTremote_assignConn, GRTremote_assignConn, DOAS_PRIV_CONFIG, DOAS_RF_NOREPLICATE),
    V_FNPUT("^[ \t]*GRTassignconn[ \t]+([-+A-Za-z0-9_!#$^&*=|{}<>?`~]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([Yy]es)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]+)", GRTremote_assignConn, GRTremote_assignConn, DOAS_PRIV_CONFIG, DOAS_RF_NOREPLICATE),
    V_FNPUT("^[ \t]*GRTASSIGNCONN[ \t]+([-+A-Za-z0-9_!#$^&*=|{}<>?`~]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([Nn]o)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]+)", GRTremote_assignConn, GRTremote_assignConn, DOAS_PRIV_CONFIG, DOAS_RF_NOREPLICATE),
    V_FNPUT("^[ \t]*GRTassignconn[ \t]+([-+A-Za-z0-9_!#$^&*=|{}<>?`~]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([Nn]o)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]+)", GRTremote_assignConn, GRTremote_assignConn, DOAS_PRIV_CONFIG, DOAS_RF_NOREPLICATE),
    V_FNPUT("^[ \t]*(abc)", abc, NULL, DOAS_PRIV_CONTROL, DOAS_RF_PRIORITY),
    V_ENDFNPUTTABLE
};

/*******************************************************************
**
*** Function:   app_dataexchange_overrides
***
**  Purpose:    Override baseline VDB-Library functions for the
**              dataexchange table.
**
**  Note:       It is *VERY* important to rename this routine based on the
**              table the override is for.  For example, if one is overriding
**              field access/fnputs for the remote table then this routine 
**              must be called "app_remote_overrides".
*/
extern "C" VDB_OVERRIDES_REMOTE void app_remote_overrides(slot tableNumber)
{
        v_readAppFnputTable(tableNumber, app_remoteFputTbl);
}

/***********************************************************************
 **
 ** Function:  GRTremote_assignConn
 **
 ** Purpose:    Assign a connection to a remote with emprise value.
 **
 ** Output:     Returns OAS_TRUE/OAS_FALSE to indicate success/failure
 **
 */
static oas_boolean_t GRTremote_assignConn(
    slot        dbNumber,   // input database number
    slot        recnumber,  // input record number
    char* comStr,    // input command string (e.g. "command on")
    user        uPriv,      // input user access level
    TRegEx& regExp,    // input Regular expression match
    VDBERROR* dberr)     // output pointer to return error code
{
    set* pdbConn;
    slot connNumber;
    int empriseValue;


#define CNO_PARM_IDX    1
#define COST_PARM_IDX   2
#define FAIL_PARM_IDX   3
#define INH_PARM_IDX    4
#define GOOD_PARM_IDX   5
#define BAD_PARM_IDX    6
#define EMPRISE_PARM_IDX    7

    cpu_debug(CPU_DEBUG_ALWAYS,
        "At the top of GRTremote_assignConn fnput with command string: %s", comStr);


    // Chop the emprise value off the end of the command string to get 
    // the command string we need for the baseline call.
    TFlexString myCommandString = comStr;
    myCommandString.ReplaceSubString("GRTassignconn", "assignconn");  // Replace the GRT fnput name with the baseline fnput name.
    int lastIndex = myCommandString.LastCharIndex();
    myCommandString.RemoveChar(lastIndex);  // Remove the emprise value off the end of the command string.  Assumes
                                            // it is only one character long.  GRT will need to make this more robust.



    empriseValue = atoi(regExp.Register(EMPRISE_PARM_IDX));

    // Get the connection number.  Need it for later.
    if (!sisdig(regExp.Register(CNO_PARM_IDX)))
    {
        /* A connection name has been given.  Find the connection number. */
        if (pdbConn = v_dblock(DATABASE_CONNECTION, REQ_SAFE_READ, dberr))
        {
            connNumber = seifnd((set*)pdbConn, 0,
                (char*)regExp.Register(CNO_PARM_IDX));

            v_dbunlock(DATABASE_CONNECTION, REQ_SAFE_READ, DISP_UN_MOD);
        }
        else
            return (OAS_FALSE);
    }
    else
        connNumber = atoi(regExp.Register(CNO_PARM_IDX));

    if (connNumber == 0)
    {
        cpu_debug(CPU_DEBUG_ALWAYS,
            "Received bad connection in command string");
        return (OAS_FALSE);
    }



    // Call the baseline fnput without the emprise value at the end
    cpu_debug(CPU_DEBUG_ALWAYS,
        "About to call baseline assignConn fnput with command string: %s", myCommandString.Get());

    if (v_fnput(DATABASE_REMOTE, recnumber, myCommandString.Get(), dberr) == OAS_FALSE)
    {
        cpu_debug(CPU_DEBUG_ALWAYS,
            "Unable to call baseline assignConn fnput with command string: %s", myCommandString.Get());
        return (OAS_FALSE);
    }
    else
    {
        cpu_debug(CPU_DEBUG_ALWAYS,"Baseline assignConn fnput call returned success.  :)");
    }

    // GRT updates the remconnjoin record with the emprise value.
    if (updateEmpriseValue(recnumber, connNumber, empriseValue, dberr) == OAS_FALSE)
    {
        cpu_debug(CPU_DEBUG_ALWAYS,
            "Unable to update remconnjoin with emprise value for remote: %d, connection: %d, empriseValue: %d",
            recnumber, connNumber, empriseValue);
        return (OAS_FALSE);
    }

    return(OAS_TRUE);

}

/***********************************************************************
 **
 ** Function:  updateEmpriseValue
 **
 ** Purpose:    For a given connection and remote, update the emprise value
 **
 ** Output:     Returns OAS_TRUE/OAS_FALSE to indicate success/failure
 **
 */
static oas_boolean_t updateEmpriseValue(
    slot remoteNumber,
    slot connNumber,
    int empriseValue,
    VDBERROR* pDberr)
{
    cpu_debug(CPU_DEBUG_ALWAYS,
        "At the top of the routine to update remconnjoin record with emprise value for remote: %d, connection: %d, emprise: %d",
        remoteNumber, connNumber, empriseValue);

    // TODO: find and update the remconnjoin record with the empriseValue.
    // Leaving this as an exercise for GRT.

    return OAS_TRUE;

}

/***********************************************************************
 **
 ** Function:  abc
 **
 ** Purpose:    just another fnput
 **
 ** Output:     Returns OAS_TRUE/OAS_FALSE to indicate success/failure
 **
 */
static oas_boolean_t abc(
    slot        dbNumber,   // input database number
    slot        recnumber,  // input record number
    char* comStr,    // input command string (e.g. "command on")
    user        uPriv,      // input user access level
    TRegEx& regExp,    // input Regular expression match
    VDBERROR* dberr)     // output pointer to return error code
{
    cpu_debug(CPU_DEBUG_ALWAYS,
        "At the top of abc fnput with command string: %s", comStr);
    return OAS_TRUE;
}

